rm(list=ls())
library(copula)
library(openxlsx)
####Generating 10-observation of in control parameter
LCL= 4.352567
UCL=101.771027
r=0.844246
lam1=120.97
lam2=99.10
theta=0.26
Fvar<-function(t)
{-1+exp(-t/lam1)+exp(-t/lam2)+((1-exp(-t/lam1))^(-theta)+(1-exp(-t/lam2))^(-theta)-1)^(-1/theta)}

A<-integrate(Fvar,0,+Inf)
ET<-A$value


T1=c(8,23,22,447,30,24,7,511,53,15,7,141,96,149,536,17,185,292,22,15,152,402,13,39,12,113,132,34,2,130)
T2=c(16,13,28,318,12,245,9,30,196,154,333,8,38,70,25,4,117,114,159,108,362,24,66,46,40,201,156,30,25,26)
Data1<-cbind(T1,T2)


#############Z=rT+(1-r)Z
#LCL= 10.18738
#UCL=400
#r=0.9999
Data=apply(Data1,1,min)
ZZ=matrix(NA,ncol=1,nrow=30)
Z=ET
for( i in 1:30)
{
  Z=r*Data[i]+(1-r)*Z
  ZZ[i]=Z
}

LCL=matrix(LCL,ncol=1,nrow=35)
UCL=matrix(UCL,ncol=1,nrow=35)
#####EWMA-TBE chart
plot(ZZ,type="b", lwd = 1, xlab=expression(italic(i)),ylab=expression(italic(Z)),xlim=c(0,35)   )
points( 4,ZZ[4], col = "red",type = 'o')
points( 18,ZZ[18], col = "red",type = 'o')
points( 21,ZZ[21], col = "red",type = 'o')
points( 27,ZZ[27], col = "red",type = 'o')
x=seq(0,34,1)
lines(LCL,lwd=1)
lines(UCL,lwd=1)

text(33,20, labels = c("LCL"))
text(33,130, labels = c("UCL"))
#####Phase II
####Generating 10-observation of in control parameter
lam1=100.2308
lam2=77.80769
theta=0.08
Fvar<-function(t)
{-1+exp(-t/lam1)+exp(-t/lam2)+((1-exp(-t/lam1))^(-theta)+(1-exp(-t/lam2))^(-theta)-1)^(-1/theta)}

A<-integrate(Fvar,0,+Inf)
ET<-A$value
x<-mvdc(claytonCopula(param=0.26,dim=2)
        ,margins = c("exp","exp"),
        paramMargins =list(list(1/lam1),list(1/lam2)))
Data1=rMvdc(10,x)
####Generating 10-observation of out-of- control parameter
lam1=100.2308*0.5
lam2=77.80769*1.2
x<-mvdc(claytonCopula(param=0.26,dim=2)
        ,margins = c("exp","exp"),
        paramMargins =list(list(1/lam1),list(1/lam2)))
Data2=rMvdc(10,x)

#############Z=rT+(1-r)Z
LCL=4.587966
UCL=139.2732
r=0.979235
Data3=rbind(Data1,Data2)
Data=apply(Data3,1,min)
ZZ=matrix(NA,ncol=1,nrow=20)
Z=ET
for( i in 1:20)
{
  
  Z=r*Data[i]+(1-r)*Z
  ZZ[i]=Z
}

LCL=matrix(LCL,ncol=1,nrow=23)
UCL=matrix(UCL,ncol=1,nrow=23)


#####EWMA-TBE chart
plot(ZZ,type="b", lwd = 1, xlab=expression(italic(i)),ylab=expression(italic(Z)))

lines(LCL,lwd=1)
lines(UCL,lwd=1)
text(2,LCL+5, labels = c("LCL"))
text(2,UCL-5, labels = c("UCL"))
write.xlsx(ZZ, file = "D:\\myworkbook.xlsx",
           sheetName = "result", append = FALSE)
########################################
ZZ=read.xlsx(xlsxFile = "D://333.xlsx")
ZZ=ZZ[[1]]
plot(ZZ,type="b", lwd = 1, xlab=expression(italic(i)),ylab=expression(italic(Z)),xlim=c(0,23) ,ylim=c(0,139.2732+5)  )

points( 18,ZZ[18], col = "red",type = 'o')

#lines(LCL,lwd=1)
#lines(UCL,lwd=1)
x=seq(0,22,1)
lines(x=x,y=UCL)
lines(x=x,y=LCL)
text(22,LCL+9, labels = expression(italic(LCL)))
text(22,UCL+6, labels =expression(italic(UCL)))